/* Copyright 2018 Yuki Rea <null-src.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef ST110R2_H
#define ST110R2_H

#include "quantum.h"

/* This a shortcut to help you visually see your layout.
 *
 * The first section contains all of the arguments representing the physical
 * layout of the board and position of the keys.
 *
 * The second converts the arguments into a two-dimensional array which
 * represents the switch matrix.
 */

#define LAYOUT(                                                                                                    \
    K00, K02, K03, K04, K05, K06, K07, K08, K09, K0B, K0C, K0D, K0E, K60, K61, K62,                                \
    K10, K11, K12, K13, K14, K15, K16, K17, K18, K19, K1A, K1B, K1C, K1D, K1E, K63, K64, K65, K6D, K6E, K70, K71,  \
    K20, K21, K22, K23, K24, K25, K26, K27, K28, K29, K2A, K2B, K2C, K66, K67, K68, K72, K73, K74,                 \
    K30, K31, K32, K33, K34, K35, K36, K37, K38, K39, K3A, K3B, K3C, K3E, K76, K77, K78, K75,                      \
    K40, K41, K42, K43, K44, K45, K46, K47, K48, K49, K4A, K4B, K4C, K4D, K69, K79, K7A, K7B,                      \
    K50, K51, K52, K53, K54, K55, K57, K58, K59, K5A, K5D, K5E, K6A, K6B, K6C, K7D, K7E, K7C)                      \
                                                                                                                   \
{                                                                                                                  \
    { K00,   KC_NO ,K02,   K03,   K04,   K05,   K06,   K07,   K08,   K09,   KC_NO, K0B,   K0C,   K0D,   K0E   },   \
    { K10,   K11,   K12,   K13,   K14,   K15,   K16,   K17,   K18,   K19,   K1A,   K1B,   K1C,   K1D,   K1E   },   \
    { K20,   K21,   K22,   K23,   K24,   K25,   K26,   K27,   K28,   K29,   K2A,   K2B,   K2C,   KC_NO, KC_NO },   \
    { K30,   K31,   K32,   K33,   K34,   K35,   K36,   K37,   K38,   K39,   K3A,   K3B,   K3C,   KC_NO, K3E   },   \
    { K40,   K41,   K42,   K43,   K44,   K45,   K46,   K47,   K48,   K49,   K4A,   K4B,   K4C,   K4D,   KC_NO },   \
    { K50,   K51,   K52,   K53,   K54,   K55,   KC_NO ,K57,   K58,   K59,   K5A,   KC_NO, KC_NO, K5D,   K5E   },   \
    { K60,   K61,   K62,   K63,   K64,   K65,   K66,   K67,   K68,   K69,   K6A,   K6B,   K6C,   K6D,   K6E   },   \
    { K70,   K71,   K72,   K73,   K74,   K75,   K76,   K77,   K78,   K79,   K7A,   K7B,   K7C,   K7D,   K7E   }    \
}

#endif


void pwm_timer_init(void);
void pwm_timer_enable(void);
void pwm_timer_disable(void);
